import pygame
from random import *

def keyPressed(k):
    global s, t
    if k.key == pygame.K_RETURN:
        t = s
        s = ""
        return
    if k.key == pygame.K_BACKSPACE and len(s)>0:
        s = s[:-1]
    else:
        s = s + chr(k.key)

def text (s, x, y6, size=24, f=None):
    if f == None:                   # Create a font if needed
        f = pygame.font.SysFont(None, size)
    text = f.render(s, 1, (0,0,0))  # Render the string in black
    screen.blit(text, (x, y))

def draw ():
    global s, t
    screen.fill((200,200,200))
    text ("Enter a string: ", 10, 100, 24, f)
    text (s, 20, 130, 24, f)
    print("   ", len(s), s)
    if (t != ""):
        text ("Completed string is "+t, 20, 150, 24, f)

def keyReleased (k):
    pass

FPS = 30
width = 400
height = 400
pygame.init()
screen = pygame.display.set_mode((width, height))
clock = pygame.time.Clock()
s = ""
t = ""
f = pygame.font.SysFont("Arial", 24)
while True:
    clock.tick(FPS)
    mouseX, mouseY = pygame.mouse.get_pos()
    for event in pygame.event.get():
         if event.type == pygame.QUIT:
             quit()
         if event.type == pygame.KEYDOWN:
             keyPressed(event)
         if event.type == pygame.KEYUP:
             keyReleased(event)
    draw()
    pygame.display.update()